"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.authInfoHandler = authInfoHandler;
exports.defineAuthInfoRoutes = defineAuthInfoRoutes;
var _constants = require("../../../utils/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function authInfoHandler({
  searchGuardBackend,
  logger
}) {
  return async function (context, request, response) {
    try {
      const body = await searchGuardBackend.authinfo(request.headers);
      // Avoid Internal IP Disclosure Pattern
      // https://floragunn.atlassian.net/browse/ITT-2387
      delete body.remote_address;
      return response.ok({
        body
      });
    } catch (error) {
      logger.error(`authInfoHandler: ${error.stack}`);
      return response.internalError({
        body: error
      });
    }
  };
}
function defineAuthInfoRoutes({
  searchGuardBackend,
  kibanaCore,
  logger
}) {
  const router = kibanaCore.http.createRouter();
  router.get({
    path: `${_constants.API_ROOT}/auth/authinfo`,
    validate: false,
    options: {
      authRequired: true
    }
  }, authInfoHandler({
    searchGuardBackend,
    logger
  }));
} // end module
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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